; #------------------------------------------------------------------------#
; |                                                                        |
; |   riscos.i                                                             |
; |                                                                        |
; |   RiscOS definitions.                                                  |
; |                                                                        |
; |   Copyright 1996-99, Frank A. Vorstenbosch                             |
; |                                                                        |
; #------------------------------------------------------------------------#

                .include "macros.i"

EIDOS_SWI_CHUNK = 0x84440
EIDOS_ERR_CHUNK = EIDOS_SWI_CHUNK*256


; +---------------------------------------------------------------------+
; |                                                                     |
; |   RiscOS function calls.                                            |
; |                                                                     |
; +---------------------------------------------------------------------+

; ----- magic value to OR into SWI number -------------------------------

RETURN_ERROR    = 0x20000

                .macro  swix,n
                swi     (\&n)|RETURN_ERROR
                .endm


; ----- Low level OS routines -------------------------------------------

OS_AbortTrap                    = 0x067
OS_AddCallBack                  = 0x054
OS_AddToVector                  = 0x047
OS_Args                         = 0x009
OS_BGet                         = 0x00a
OS_BPut                         = 0x00b
OS_BinaryToDecimal              = 0x028
OS_BreakCtrl                    = 0x018
OS_BreakPt                      = 0x017
OS_Byte                         = 0x006
OS_CLI                          = 0x005
OS_CRC                          = 0x05b
OS_CallAVector                  = 0x034
OS_CallAfter                    = 0x03b
OS_CallBack                     = 0x015
OS_CallEvery                    = 0x03c
OS_ChangeDynamicArea            = 0x02a
OS_ChangeEnvironment            = 0x040
OS_ChangeRedirection            = 0x05e
OS_ChangedBox                   = 0x05a
OS_CheckModeValid               = 0x03f
OS_Claim                        = 0x01f
OS_ClaimDeviceVector            = 0x04b
OS_ClaimProcessorVector         = 0x069
OS_ClaimSWI                     = 0x062
OS_ClaimScreenMemory            = 0x041
OS_Confirm                      = 0x059
OS_Control                      = 0x00f
OS_ConvertBinary1               = 0x0dd
OS_ConvertBinary2               = 0x0de
OS_ConvertBinary3               = 0x0df
OS_ConvertBinary4               = 0x0e0
OS_ConvertCardinal1             = 0x0d5
OS_ConvertCardinal2             = 0x0d6
OS_ConvertCardinal3             = 0x0d7
OS_ConvertCardinal4             = 0x0d8
OS_ConvertDateAndTime           = 0x0c1
OS_ConvertFileSize              = 0x0ec
OS_ConvertFixedFileSize         = 0x0eb
OS_ConvertFixedNetStation       = 0x0e9
OS_ConvertHex1                  = 0x0d0
OS_ConvertHex2                  = 0x0d1
OS_ConvertHex4                  = 0x0d2
OS_ConvertHex6                  = 0x0d3
OS_ConvertHex8                  = 0x0d4
OS_ConvertInteger1              = 0x0d9
OS_ConvertInteger2              = 0x0da
OS_ConvertInteger3              = 0x0db
OS_ConvertInteger4              = 0x0dc
OS_ConvertNetStation            = 0x0ea
OS_ConvertSpacedCardinal1       = 0x0e1
OS_ConvertSpacedCardinal2       = 0x0e2
OS_ConvertSpacedCardinal3       = 0x0e3
OS_ConvertSpacedCardinal4       = 0x0e4
OS_ConvertSpacedInteger1        = 0x0e5
OS_ConvertSpacedInteger2        = 0x0e6
OS_ConvertSpacedInteger3        = 0x0e7
OS_ConvertSpacedInteger4        = 0x0e8
OS_ConvertStandardDateAndTime   = 0x0c0
OS_DelinkApplication            = 0x04d
OS_DynamicArea                  = 0x066
OS_EnterOS                      = 0x016
OS_EvaluateExpression           = 0x02d
OS_Exit                         = 0x011    ; R0=return code
OS_ExitAndDie                   = 0x050
OS_FSControl                    = 0x029
OS_File                         = 0x008
OS_Find                         = 0x00d
OS_FindMemMapEntries            = 0x060
OS_GBPB                         = 0x00c
OS_GSInit                       = 0x025
OS_GSRead                       = 0x026
OS_GSTrans                      = 0x027
OS_GenerateError                = 0x02b
OS_GenerateEvent                = 0x022
OS_GetEnv                       = 0x010
OS_Heap                         = 0x01d
OS_HeapSort                     = 0x04f
OS_InstallKeyHandler            = 0x03e
OS_IntOff                       = 0x014
OS_IntOn                        = 0x013
OS_MMUControl                   = 0x06b
OS_Memory                       = 0x068
OS_Module                       = 0x01e
OS_Mouse                        = 0x01c
OS_NewLine                      = 0x003
OS_Plot                         = 0x045
OS_Pointer                      = 0x064
OS_PrettyPrint                  = 0x044
OS_PrintChar                    = 0x05d
OS_ReadArgs                     = 0x049
OS_ReadC                        = 0x004
OS_ReadDefaultHandler           = 0x055
OS_ReadDynamicArea              = 0x05c
OS_ReadEscapeState              = 0x02c
OS_ReadLine                     = 0x00e
OS_ReadMemMapEntries            = 0x052
OS_ReadMemMapInfo               = 0x051
OS_ReadModeVariable             = 0x035
OS_ReadMonotonicTime            = 0x042    ; -> R0=number of 10ms intervals since last boot
OS_ReadPalette                  = 0x02f
OS_ReadPoint                    = 0x032
OS_ReadRAMFsLimits              = 0x04a
OS_ReadSysInfo                  = 0x058
OS_ReadUnsigned                 = 0x021
OS_ReadVarVal                   = 0x023
OS_ReadVduVariables             = 0x031
OS_Release                      = 0x020
OS_ReleaseDeviceVector          = 0x04c
OS_ReleaseSWI                   = 0x063
OS_RelinkApplication            = 0x04e
OS_RemoveCallBack               = 0x05f
OS_RemoveCursors                = 0x036
OS_RemoveTickerEvent            = 0x03d
OS_Reset                        = 0x06a
OS_RestoreCursors               = 0x037
OS_SWINumberFromString          = 0x039
OS_SWINumberToString            = 0x038
OS_ScreenMode                   = 0x065
OS_SerialOp                     = 0x057
OS_ServiceCall                  = 0x030
OS_SetCallBack                  = 0x01b
OS_SetColour                    = 0x061
OS_SetECFOrigin                 = 0x056
OS_SetEnv                       = 0x012
OS_SetMemMapEntries             = 0x053
OS_SetVarVal                    = 0x024
OS_SpriteOp                     = 0x02e
OS_SubstituteArgs               = 0x043
OS_SynchroniseCodeAreas         = 0x06e    ; R0=flags <0>='be fast' R1=low address R2=high address (inclusive)
OS_UnusedSWI                    = 0x019
OS_UpCall                       = 0x033
OS_UpdateMEMC                   = 0x01a
OS_ValidateAddress              = 0x03a
OS_Word                         = 0x007
OS_Write0                       = 0x002    ; R0=string
OS_WriteC                       = 0x000    ; R0=character
OS_WriteEnv                     = 0x048
OS_WriteI                       = 0x100    ; character OR-ed into low byte of swi number
OS_WriteN                       = 0x046
OS_WriteS                       = 0x001    ; write string directly following SWI instruction to stdout
OS_WriteInline                  = OS_WriteS

; ----- Miscellaneous ---------------------------------------------------

FPEmulator_Version              = 0x40480
IIC_Control                     = 0x240    ; R0=device R1=list R2=length
TimeShare_InterruptShedule      = 0x4b544

; ----- file systems ----------------------------------------------------

                .ifdef ADFS
ADFS_ControllerType             = 0x40248
ADFS_DescribeDisc               = 0x40245
ADFS_DiscOp                     = 0x40240
ADFS_Drives                     = 0x40242
ADFS_ECCSAndRetries             = 0x40250
ADFS_FlpProcessDCB              = 0x40247
ADFS_FreeSpace                  = 0x40243
ADFS_FreeSpace64                = 0x40252
ADFS_HDC                        = 0x40241
ADFS_IDEUserOp                  = 0x4024b
ADFS_LockIDE                    = 0x40251
ADFS_MiscOp                     = 0x4024c
ADFS_NOP2                       = 0x4024e
ADFS_NOP3                       = 0x4024f
ADFS_PowerControl               = 0x40249
ADFS_Retries                    = 0x40244
ADFS_SectorDiscOp               = 0x4024d
ADFS_SetIDEController           = 0x4024a
ADFS_VetFormat                  = 0x40246
                .endif

                .ifdef DOSFS
DOSFS_DiscFormat                = 0x44b00
DOSFS_LayoutStructure           = 0x44b01
                .endif

                .ifdef DEVICEFS
DeviceFS_CallDevice             = 0x42744
DeviceFS_Deregister             = 0x42741
DeviceFS_DeregisterObjects      = 0x42743
DeviceFS_ReceivedCharacter      = 0x42746
DeviceFS_Register               = 0x42740
DeviceFS_RegisterObjects        = 0x42742
DeviceFS_Threshold              = 0x42745
DeviceFS_TransmitCharacter      = 0x42747
                .endif

                .ifdef FSLOCK
FSLock_ChangeStatus             = 0x44782
FSLock_Status                   = 0x44781
FSLock_Version                  = 0x44780
                .endif

                .ifdef FILECORE
FileCore_Create                 = 0x40541
FileCore_DescribeDisc           = 0x40545
FileCore_DiscFormat             = 0x40547
FileCore_DiscOp                 = 0x40540
FileCore_DiscardReadSectorsCache = 0x40546
FileCore_Drives                 = 0x40542
FileCore_FloppyStructure        = 0x40544
FileCore_FreeSpace              = 0x40543
FileCore_FreeSpace64            = 0x4054b
FileCore_LayoutStructure        = 0x40548
FileCore_MiscOp                 = 0x40549
FileCore_SectorDiscOp           = 0x4054a
                .endif

                .ifdef HOSTFS
HostFS_HostVdu                  = 0x40100
HostFS_TubeVdu                  = 0x40101
HostFS_WriteC                   = 0x40102
                .endif

                .ifdef NETFS
NetFS_ConvertDate               = 0x4004b
NetFS_DoFSOp                    = 0x40048
NetFS_DoFSOpToGivenFS           = 0x4004c
NetFS_EnableCache               = 0x40051
NetFS_EnumerateFS               = 0x4004a
NetFS_EnumerateFSContexts       = 0x4004e
NetFS_EnumerateFSList           = 0x40049
NetFS_GetObjectUID              = 0x40050
NetFS_ReadCurrentContext        = 0x40044
NetFS_ReadFSName                = 0x40042
NetFS_ReadFSNumber              = 0x40040
NetFS_ReadFSTimeouts            = 0x40046
NetFS_ReadUserId                = 0x4004f
NetFS_SetCurrentContext         = 0x40045
NetFS_SetFSName                 = 0x40043
NetFS_SetFSNumber               = 0x40041
NetFS_SetFSTimeouts             = 0x40047
NetFS_UpdateFSList              = 0x4004d
                .endif

                .ifdef RAMFS
RamFS_DescribeDisc              = 0x40785
RamFS_DiscOp                    = 0x40780
RamFS_Drives                    = 0x40782
RamFS_FreeSpace                 = 0x40783
RamFS_NOP1                      = 0x40781
RamFS_NOP2                      = 0x40784
                .endif

                .ifdef RESOURCEFS
ResourceFS_DeregisterFiles      = 0x41b41
ResourceFS_RegisterFiles        = 0x41b40
                .endif

                .ifdef SCSIFS
SCSIFS_DescribeDisc             = 0x40985
SCSIFS_DiscOp                   = 0x40980
SCSIFS_Drives                   = 0x40982
SCSIFS_FreeSpace                = 0x40983
SCSIFS_FreeSpace64              = 0x40987
SCSIFS_NOP1                     = 0x40981
SCSIFS_NOP2                     = 0x40984
SCSIFS_TestReady                = 0x40986
                .endif


; ----- BASIC -----------------------------------------------------------

                .ifdef BASIC
BASICTrans_Error                = 0x42c81
BASICTrans_HELP                 = 0x42c80
BASICTrans_Message              = 0x42c82
                .endif


; ----- Buffer management -----------------------------------------------

                .ifdef BUFFER
Buffer_Create                   = 0x42940
Buffer_Deregister               = 0x42943
Buffer_GetInfo                  = 0x42947
Buffer_InternalInfo             = 0x42949
Buffer_LinkDevice               = 0x42945
Buffer_ModifyFlags              = 0x42944
Buffer_Register                 = 0x42942
Buffer_Remove                   = 0x42941
Buffer_Threshold                = 0x42948
Buffer_UnlinkDevice             = 0x42946
                .endif


; ----- CDROMs ----------------------------------------------------------

                .ifdef CDROM
ATAPI_GetDrives                 = 0x4a740
CDFS_ConvertDriveToDevice       = 0x41e80
CDFS_DescribeDisc               = 0x41e86
CDFS_GetBufferSize              = 0x41e82
CDFS_GetNumberOfDrives          = 0x41e84
CDFS_GiveFileType               = 0x41e85
CDFS_SetBufferSize              = 0x41e81
CDFS_SetNumberOfDrives          = 0x41e83
CD_AudioControl                 = 0x4125d
CD_AudioLevel                   = 0x4125f
CD_AudioPause                   = 0x4124d
CD_AudioStatus                  = 0x41254
CD_ByteCopy                     = 0x41262
CD_CheckDrive                   = 0x41250
CD_CloseDrawer                  = 0x4125b
CD_Control                      = 0x41257
CD_ConvertToLBA                 = 0x41264
CD_ConvertToMSF                 = 0x41265
CD_DiscChanged                  = 0x41251
CD_DiscHasChanged               = 0x41256
CD_DiscUsed                     = 0x41253
CD_DriveReady                   = 0x41244
CD_DriveStatus                  = 0x41243
CD_EjectButton                  = 0x41248
CD_EnquireAddress               = 0x41249
CD_EnquireDataMode              = 0x4124a
CD_EnquireTrack                 = 0x4124e
CD_GetParameters                = 0x41245
CD_Identify                     = 0x41263
CD_Inquiry                      = 0x41255
CD_IsDrawerLocked               = 0x4125c
CD_LastError                    = 0x4125e
CD_OpenDrawer                   = 0x41247
CD_PlayAudio                    = 0x4124b
CD_PlayTrack                    = 0x4124c
CD_Prefetch                     = 0x41259
CD_ReadData                     = 0x41241
CD_ReadSubChannel               = 0x4124f
CD_Register                     = 0x41260
CD_Reset                        = 0x4125a
CD_SeekTo                       = 0x41242
CD_SetParameters                = 0x41246
CD_StopDisc                     = 0x41252
CD_Supported                    = 0x41258
CD_Unregister                   = 0x41261
CD_Version                      = 0x41240
                .endif


; ----- Cache -----------------------------------------------------------

Cache_Cacheable                 = 0x00281
Cache_Control                   = 0x00280
Cache_Disruptive                = 0x00283
Cache_Flush                     = 0x00284
Cache_Updateable                = 0x00282

; ----- ColourPicker and ColourTrans ------------------------------------

                .ifdef COLOUR
ColourPicker_CloseDialogue      = 0x47703
ColourPicker_DeregisterModel    = 0x47701
ColourPicker_HelpReply          = 0x47707
ColourPicker_ModelSWI           = 0x47708
ColourPicker_OpenDialogue       = 0x47702
ColourPicker_ReadDialogue       = 0x47705
ColourPicker_RegisterModel      = 0x47700
ColourPicker_SetColour          = 0x47706
ColourPicker_UpdateDialogue     = 0x47704

ColourTrans_ColourNumberToGCOL  = 0x4074d
ColourTrans_ConvertCIEToRGB     = 0x40756
ColourTrans_ConvertCMYKToRGB    = 0x4075b
ColourTrans_ConvertDeviceColour = 0x40753
ColourTrans_ConvertDevicePalette = 0x40754
ColourTrans_ConvertHSVToRGB     = 0x40759
ColourTrans_ConvertRGBToCIE     = 0x40755
ColourTrans_ConvertRGBToCMYK    = 0x4075a
ColourTrans_ConvertRGBToHSV     = 0x40758
ColourTrans_GCOLToColourNumber  = 0x4074c
ColourTrans_GenerateTable       = 0x40763
ColourTrans_InvalidateCache     = 0x40750
ColourTrans_MiscOp              = 0x4075f
ColourTrans_ReadCalibration     = 0x40752
ColourTrans_ReadPalette         = 0x4075c
ColourTrans_ReturnColourNumber  = 0x40744
ColourTrans_ReturnColourNumberForMode = 0x40746
ColourTrans_ReturnFontColours   = 0x4074e
ColourTrans_ReturnGCOL          = 0x40742
ColourTrans_ReturnGCOLForMode   = 0x40745
ColourTrans_ReturnOppColourNumber = 0x40749
ColourTrans_ReturnOppColourNumberForMode = 0x4074b
ColourTrans_ReturnOppGCOL       = 0x40747
ColourTrans_ReturnOppGCOLForMode = 0x4074a
ColourTrans_SelectGCOLTable     = 0x40741
ColourTrans_SelectTable         = 0x40740
ColourTrans_SetCalibration      = 0x40751
ColourTrans_SetColour           = 0x4075e
ColourTrans_SetFontColours      = 0x4074f
ColourTrans_SetGCOL             = 0x40743
ColourTrans_SetOppGCOL          = 0x40748
ColourTrans_SetOppTextColour    = 0x40762
ColourTrans_SetTextColour       = 0x40761
ColourTrans_WriteCalibrationToFile = 0x40757
ColourTrans_WriteLoadingsToFile = 0x40760
ColourTrans_WritePalette        = 0x4075d
                .endif

; ----- DMA -------------------------------------------------------------

                .ifdef DMA
DMA_DeregisterChannel           = 0x46141
DMA_ExamineTransfer             = 0x46146
DMA_QueueTransfer               = 0x46142
DMA_RegisterChannel             = 0x46140
DMA_ResumeTransfer              = 0x46145
DMA_SuspendTransfer             = 0x46144
DMA_TerminateTransfer           = 0x46143
                .endif

; ----- Debugger --------------------------------------------------------

;;Debugger_BeingDebugged          = 0x41d41
;;Debugger_DebugAIF               = 0x41d40
;;Debugger_Disassemble            = 0x40380
;;Debugger_EndDebug               = 0x41d43
;;Debugger_StartDebug             = 0x41d42

; ----- Sprites ---------------------------------------------------------

;;DragASprite_Start               = 0x42400
;;DragASprite_Stop                = 0x42401
;;DragAnObject_Start              = 0x49c40
;;DragAnObject_Stop               = 0x49c41

; ----- High level drawing routines -------------------------------------

                .ifdef DRAW
Draw_Fill                       = 0x40702
Draw_FillFP                     = 0x40703
Draw_FlattenPath                = 0x40708
Draw_FlattenPathFP              = 0x40709
Draw_ProcessPath                = 0x40700
Draw_ProcessPathFP              = 0x40701
Draw_Stroke                     = 0x40704
Draw_StrokeFP                   = 0x40705
Draw_StrokePath                 = 0x40706
Draw_StrokePathFP               = 0x40707
Draw_TransformPath              = 0x4070a
Draw_TransformPathFP            = 0x4070b
                .endif


; ----- Filer -----------------------------------------------------------

                .ifdef FILER
FilerAction_SendSelectedDirectory = 0x40f80
FilerAction_SendSelectedFile    = 0x40f81
FilerAction_SendStartOperation  = 0x40f82
                .endif


; ----- Filter ----------------------------------------------------------

                .ifdef FILTER
Filter_DeRegisterPostFilter     = 0x42643
Filter_DeRegisterPreFilter      = 0x42642
Filter_RegisterPostFilter       = 0x42641
Filter_RegisterPreFilter        = 0x42640
                .endif


; ----- Fonts -----------------------------------------------------------

                .ifdef FONTS
Font_ApplyFields                = 0x400a7
Font_CacheAddr                  = 0x40080
Font_Caret                      = 0x40087
Font_ChangeArea                 = 0x400bf
Font_CharBBox                   = 0x4008e
Font_ConverttoOS                = 0x40088
Font_Converttopoints            = 0x40089
Font_CurrentFont                = 0x4008b
Font_CurrentRGB                 = 0x400a3
Font_DecodeMenu                 = 0x400a0
Font_FindCaret                  = 0x4008d
Font_FindCaretJ                 = 0x40096
Font_FindField                  = 0x400a6
Font_FindFont                   = 0x40081
Font_FutureFont                 = 0x4008c
Font_FutureRGB                  = 0x400a4
Font_ListFonts                  = 0x40091
Font_LookupFont                 = 0x400a8
Font_LoseFont                   = 0x40082
Font_MakeBitmap                 = 0x40099
Font_Paint                      = 0x40086
Font_ReadColourTable            = 0x40098
Font_ReadDefn                   = 0x40083
Font_ReadEncodingFilename       = 0x400a5
Font_ReadFontMax                = 0x4009c
Font_ReadFontMetrics            = 0x4009f
Font_ReadFontPrefix             = 0x4009d
Font_ReadInfo                   = 0x40084
Font_ReadScaleFactor            = 0x4008f
Font_ReadThresholds             = 0x40094
Font_ScanString                 = 0x400a1
Font_SetColourTable             = 0x400a2
Font_SetFont                    = 0x4008a
Font_SetFontColours             = 0x40092
Font_SetFontMax                 = 0x4009b
Font_SetPalette                 = 0x40093
Font_SetScaleFactor             = 0x40090
Font_SetThresholds              = 0x40095
Font_StringBBox                 = 0x40097
Font_StringWidth                = 0x40085
Font_SwitchOutputToBuffer       = 0x4009e
Font_UnCacheFile                = 0x4009a

MakePSFont_MakeFont             = 0x43440
                .endif


; ----- Free ------------------------------------------------------------

                .ifdef FREE
Free_DeRegister                 = 0x444c1
Free_Register                   = 0x444c0
                .endif


; ----- Hourglass -------------------------------------------------------

Hourglass_Colours               = 0x406c6
Hourglass_LEDs                  = 0x406c5
Hourglass_Off                   = 0x406c1
Hourglass_On                    = 0x406c0
Hourglass_Percentage            = 0x406c4
Hourglass_Smash                 = 0x406c2
Hourglass_Start                 = 0x406c3

; ----- Joystick and mouse ----------------------------------------------

                .ifdef JOYSTICK
Joystick_CalibrateBottomLeft    = 0x43f42
Joystick_CalibrateTopRight      = 0x43f41
Joystick_Read                   = 0x43f40
                .endif

; ----- Messages --------------------------------------------------------

                .ifdef MESSAGETRANS
MessageTrans_CloseFile          = 0x41504
MessageTrans_CopyError          = 0x41508
MessageTrans_Dictionary         = 0x41509
MessageTrans_EnumerateTokens    = 0x41505
MessageTrans_ErrorLookup        = 0x41506
MessageTrans_FileInfo           = 0x41500
MessageTrans_GSLookup           = 0x41507
MessageTrans_Lookup             = 0x41502
MessageTrans_MakeMenus          = 0x41503
MessageTrans_OpenFile           = 0x41501
                .endif


; ----- Networking ------------------------------------------------------

                .ifdef ECONET
Econet_AbandonAndReadReceive    = 0x40018
Econet_AbandonReceive           = 0x40003
Econet_AbandonTransmit          = 0x40008
Econet_AllocatePort             = 0x40013
Econet_ClaimPort                = 0x40015
Econet_ConvertStatusToError     = 0x4000c
Econet_ConvertStatusToString    = 0x4000b
Econet_CreateReceive            = 0x40000
Econet_DeAllocatePort           = 0x40014
Econet_DoImmediate              = 0x40017
Econet_DoTransmit               = 0x40009
Econet_EnumerateMap             = 0x4001e
Econet_EnumerateReceive         = 0x40005
Econet_EnumerateTransmit        = 0x4001f
Econet_ExamineReceive           = 0x40001
Econet_HardwareAddresses        = 0x40020
Econet_InetRxDirect             = 0x4001d
Econet_NetworkParameters        = 0x40021
Econet_NetworkState             = 0x4001a
Econet_PacketSize               = 0x4001b
Econet_PollTransmit             = 0x40007
Econet_PrintBanner              = 0x40010
Econet_ReadLocalStationAndNet   = 0x4000a
Econet_ReadProtection           = 0x4000d
Econet_ReadReceive              = 0x40002
Econet_ReadStationNumber        = 0x4000f
Econet_ReadTransportName        = 0x4001c
Econet_ReadTransportType        = 0x40011
Econet_ReleasePort              = 0x40012
Econet_SetProtection            = 0x4000e
Econet_StartImmediate           = 0x40016
Econet_StartTransmit            = 0x40006
Econet_Version                  = 0x40019
Econet_WaitForReception         = 0x40004
                .endif

                .ifdef NETMONITOR
NetMonitor_AbandonTask          = 0x80042
NetMonitor_ConvertFont          = 0x80043
NetMonitor_DefineTask           = 0x80041
NetMonitor_PrintChar            = 0x80040
NetMonitor_RestoreFont          = 0x80045
NetMonitor_StartWithCurrentFont = 0x80046
NetMonitor_StartWithInternalFont = 0x80047
NetMonitor_UseFont              = 0x80044
                .endif

                .ifdef MBUF
Mbuf_OpenSession                = 0x4a580
Mbuf_CloseSession               = 0x4a581
Mbuf_Memory                     = 0x4a582
                .endif


; ----- Printer driver --------------------------------------------------

                .ifdef NETPRINT
NetPrint_BindPSName             = 0x40206
NetPrint_ConvertStatusToString  = 0x40208
NetPrint_ListServers            = 0x40207
NetPrint_ReadPSName             = 0x40202
NetPrint_ReadPSNumber           = 0x40200
NetPrint_ReadPSTimeouts         = 0x40204
NetPrint_SetPSName              = 0x40203
NetPrint_SetPSNumber            = 0x40201
NetPrint_SetPSTimeouts          = 0x40205
                .endif

                .ifdef PDRIVER
PDriver_AbortJob                = 0x80149
PDriver_CancelJob               = 0x8014e
PDriver_CancelJobWithError      = 0x80152
PDriver_CheckFeatures           = 0x80142
PDriver_CurrentJob              = 0x80146
PDriver_DeclareDriver           = 0x80156
PDriver_DeclareFont             = 0x80155
PDriver_DrawPage                = 0x8014c
PDriver_EndJob                  = 0x80148
PDriver_EnumerateDrivers        = 0x80159
PDriver_EnumerateJobs           = 0x80150
PDriver_FontSWI                 = 0x80147
PDriver_GetRectangle            = 0x8014d
PDriver_GiveRectangle           = 0x8014b
PDriver_Info                    = 0x80140
PDriver_InsertIllustration      = 0x80154
PDriver_JPEGSWI                 = 0x8015d
PDriver_MiscOp                  = 0x8015a
PDriver_MiscOpForDriver         = 0x8015b
PDriver_PageSize                = 0x80143
PDriver_RemoveDriver            = 0x80157
PDriver_Reset                   = 0x8014a
PDriver_ScreenDump              = 0x8014f
PDriver_SelectDriver            = 0x80158
PDriver_SelectIllustration      = 0x80153
PDriver_SelectJob               = 0x80145
PDriver_SetDriver               = 0x8015c
PDriver_SetInfo                 = 0x80141
PDriver_SetPageSize             = 0x80144
PDriver_SetPrinter              = 0x80151
                .endif

                .ifdef PDUMPER
PDumper_Claim                   = 0x41b01
PDumper_CopyFilename            = 0x41b09
PDumper_Find                    = 0x41b03
PDumper_Free                    = 0x41b02
PDumper_Info                    = 0x41b00
PDumper_LookupError             = 0x41b08
PDumper_PrepareStrip            = 0x41b07
PDumper_SetColour               = 0x41b06
PDumper_StartJob                = 0x41b04
PDumper_TidyJob                 = 0x41b05
                .endif


; ----- Parallel and serial ports ---------------------------------------

Parallel_HardwareAddress        = 0x42ec0
Parallel_Op                     = 0x42ec1

; ----- Plug in cards ---------------------------------------------------

                .ifdef PODULE
Podule_CallLoader               = 0x40286
Podule_EnumerateChunks          = 0x40282
Podule_EnumerateChunksWithInfo  = 0x4028a
Podule_HardwareAddress          = 0x40289  ; R3=ROMsec -> R3<0-12>=CMOSadd <12-25>=baseaddr
Podule_HardwareAddresses        = 0x4028b
Podule_RawRead                  = 0x40287
Podule_RawWrite                 = 0x40288
Podule_ReadBytes                = 0x40284
Podule_ReadChunk                = 0x40283
Podule_ReadHeader               = 0x40281  ; R2=buffer[16] R3=ROMsec
Podule_ReadID                   = 0x40280  ; R3=ROMsec -> R0=ECid
Podule_ReadInfo                 = 0x4028d  ; R0=mask R1=buffer R2=length R3=ROMsec
Podule_ReturnNumber             = 0x4028c
Podule_SetSpeed                 = 0x4028e
Podule_WriteBytes               = 0x40285
                .endif


; ----- Support for portable RiscPC -------------------------------------

                .ifdef PORTABLE
Portable_CommandBMU             = 0x42fc4
Portable_Control                = 0x42fc1
Portable_Idle                   = 0x42fc6
Portable_ReadBMUVariable        = 0x42fc2
Portable_ReadFeatures           = 0x42fc5
Portable_Speed                  = 0x42fc0
Portable_Stop                   = 0x42fc7
Portable_WriteBMUVariable       = 0x42fc3
                .endif


; ----- SCSI controller -------------------------------------------------

                .ifdef SCSI
SCSI_Control                    = 0x403c2
SCSI_EEProm                     = 0x403c6
SCSI_Initialise                 = 0x403c1
SCSI_List                       = 0x403c8
SCSI_LogList                    = 0x41081
SCSI_LogVersion                 = 0x41080
SCSI_Op                         = 0x403c3
SCSI_ReadControlLines           = 0x403c5
SCSI_Reserve                    = 0x403c7
SCSI_Status                     = 0x403c4
SCSI_TargetControl              = 0x403c9
SCSI_Version                    = 0x403c0
                .endif


; ----- Screen blanker --------------------------------------------------

ScreenBlanker_Control           = 0x43100
ScreenModes_ReadInfo            = 0x487c0

; ----- Shared C library ------------------------------------------------

SharedCLibrary_LibInitAPCS_A    = 0x80680
SharedCLibrary_LibInitAPCS_R    = 0x80681
SharedCLibrary_LibInitModule    = 0x80682

; ----- Shell -----------------------------------------------------------

;;Shell_Create                    = 0x405c0
;;Shell_Destroy                   = 0x405c1

; ----- Sound -----------------------------------------------------------

                .ifdef SOUND
Sound_AttachNamedVoice          = 0x4018a
Sound_AttachVoice               = 0x40185
Sound_Configure                 = 0x40140
Sound_Control                   = 0x40189
Sound_ControlPacked             = 0x40186
Sound_Enable                    = 0x40141
Sound_InstallVoice              = 0x40183
Sound_LinearHandler             = 0x40145
Sound_LogScale                  = 0x40182
Sound_Mode                      = 0x40144
Sound_Pitch                     = 0x40188
Sound_QBeat                     = 0x401c6
Sound_QFree                     = 0x401c3
Sound_QInit                     = 0x401c0
Sound_QInterface                = 0x401c7
Sound_QRemove                   = 0x401c2
Sound_QSDispatch                = 0x401c4
Sound_QSchedule                 = 0x401c1
Sound_QTempo                    = 0x401c5
Sound_ReadControlBlock          = 0x4018b
Sound_RemoveVoice               = 0x40184
Sound_SampleRate                = 0x40146
Sound_SoundLog                  = 0x40181
Sound_Speaker                   = 0x40143
Sound_Stereo                    = 0x40142
Sound_Tuning                    = 0x40187
Sound_Volume                    = 0x40180
Sound_WriteControlBlock         = 0x4018c
                .endif


; ----- ? ---------------------------------------------------------------

;;Squash_Compress                 = 0x42700
;;Squash_Decompress               = 0x42701
;;Super_Sample45                  = 0x40d81
;;Super_Sample90                  = 0x40d80

; ----- Task manager ----------------------------------------------------

;;TaskManager_EnumerateTasks      = 0x42681
;;TaskManager_Shutdown            = 0x42682
;;TaskManager_TaskNameFromHandle  = 0x42680
;;TaskWindow_TaskInfo             = 0x43380

; ----- Locale routines -------------------------------------------------

                .ifdef TERRITORY
Territory_Alphabet              = 0x43052
Territory_AlphabetIdentifier    = 0x43053
Territory_AlphabetNumberToName  = 0x43045
Territory_CharacterPropertyTable = 0x43056
Territory_Collate               = 0x4305d
Territory_ControlTable          = 0x43059
Territory_ConvertDateAndTime    = 0x4304b
Territory_ConvertOrdinalsToTime = 0x43051
Territory_ConvertStandardDate   = 0x4304d
Territory_ConvertStandardDateAndTime = 0x4304c
Territory_ConvertStandardTime   = 0x4304e
Territory_ConvertTextToString   = 0x43075
Territory_ConvertTimeStringToOrdinals = 0x43050
Territory_ConvertTimeToOrdinals = 0x4304f
Territory_ConvertTimeToUTCOrdinals = 0x43049
Territory_Deregister            = 0x43042
Territory_Exists                = 0x43044
Territory_LowerCaseTable        = 0x43057
Territory_NameToNumber          = 0x43060
Territory_Number                = 0x43040
Territory_NumberToName          = 0x43043
Territory_PlainTable            = 0x4305a
Territory_ReadCalendarInformation = 0x4305f
Territory_ReadCurrentTimeZone   = 0x43048
Territory_ReadSymbols           = 0x4305e
Territory_ReadTimeZones         = 0x4304a
Territory_Register              = 0x43041
Territory_RepresentationTable   = 0x4305c
Territory_SelectAlphabet        = 0x43046
Territory_SelectKeyboardHandler = 0x43054
Territory_SetTime               = 0x43047
Territory_TransformString       = 0x43061
Territory_UpperCaseTable        = 0x43058
Territory_ValueTable            = 0x4305b
Territory_WriteDirection        = 0x43055
                .endif


; ----- Toolbox routines ------------------------------------------------

                .ifdef TOOLBOX
Toolbox_CreateObject            = 0x44ec0
Toolbox_DeleteObject            = 0x44ec1
Toolbox_CopyObject              = 0x44ec2
Toolbox_ShowObject              = 0x44ec3
Toolbox_HideObject              = 0x44ec4
Toolbox_GetObjectInfo           = 0x44ec5
Toolbox_ObjectMiscOp            = 0x44ec6
Toolbox_SetClientHandle         = 0x44ec7
Toolbox_GetClientHandle         = 0x44ec8
Toolbox_GetObjectClass          = 0x44ec9
Toolbox_GetParent               = 0x44eca
Toolbox_GetAncestor             = 0x44ecb
Toolbox_GetTemplateName         = 0x44ecc
Toolbox_RaiseToolboxEvent       = 0x44ecd
Toolbox_GetSysInfo              = 0x44ece
Toolbox_Initialise              = 0x44ecf
Toolbox_LoadResources           = 0x44ed0
Toolbox_TemplateLookUp          = 0x44efb
Toolbox_GetInternalHandle       = 0x44efc
Toolbox_RegisterPostFilter      = 0x44efd
Toolbox_RegisterPreFilter       = 0x44efe
Toolbox_RegisterObjectModule    = 0x44eff
                .endif


; ----- Wimp routines ---------------------------------------------------

                .ifdef WIMP
Wimp_AddMessages                = 0x400f6
Wimp_BaseOfSprites              = 0x400ea
Wimp_BlockCopy                  = 0x400eb
Wimp_ClaimFreeMemory            = 0x400ee
Wimp_CloseDown                  = 0x400dd
Wimp_CloseTemplate              = 0x400da
Wimp_CloseWindow                = 0x400c6
Wimp_CommandWindow              = 0x400ef
Wimp_CreateIcon                 = 0x400c2
Wimp_CreateMenu                 = 0x400d4
Wimp_CreateSubMenu              = 0x400e8
Wimp_CreateWindow               = 0x400c1
Wimp_DecodeMenu                 = 0x400d5
Wimp_DeleteIcon                 = 0x400c4
Wimp_DeleteWindow               = 0x400c3
Wimp_DragBox                    = 0x400d0
Wimp_Extend                     = 0x400fb
Wimp_ForceRedraw                = 0x400d1
Wimp_GetCaretPosition           = 0x400d3
Wimp_GetIconState               = 0x400ce
Wimp_GetMenuState               = 0x400f4
Wimp_GetPointerInfo             = 0x400cf
Wimp_GetRectangle               = 0x400ca
Wimp_GetWindowInfo              = 0x400cc
Wimp_GetWindowOutline           = 0x400e0
Wimp_GetWindowState             = 0x400cb
Wimp_Initialise                 = 0x400c0
Wimp_LoadTemplate               = 0x400db
Wimp_OpenTemplate               = 0x400d9
Wimp_OpenWindow                 = 0x400c5
Wimp_PlotIcon                   = 0x400e2
Wimp_Poll                       = 0x400c7
Wimp_PollIdle                   = 0x400e1
Wimp_ProcessKey                 = 0x400dc
Wimp_ReadPalette                = 0x400e5
Wimp_ReadPixTrans               = 0x400ed
Wimp_ReadSysInfo                = 0x400f2
Wimp_RedrawWindow               = 0x400c8
Wimp_RegisterFilter             = 0x400f5
Wimp_RemoveMessages             = 0x400f7
Wimp_ReportError                = 0x400df
Wimp_ResizeIcon                 = 0x400fc
Wimp_SendMessage                = 0x400e7
Wimp_SetCaretPosition           = 0x400d2
Wimp_SetColour                  = 0x400e6
Wimp_SetColourMapping           = 0x400f8
Wimp_SetExtent                  = 0x400d7
Wimp_SetFontColours             = 0x400f3
Wimp_SetIconState               = 0x400cd
Wimp_SetMode                    = 0x400e3
Wimp_SetPalette                 = 0x400e4
Wimp_SetPointerShape            = 0x400d8
Wimp_SetWatchdogState           = 0x400fa
Wimp_SlotSize                   = 0x400ec
Wimp_SpriteOp                   = 0x400e9
Wimp_StartTask                  = 0x400de
Wimp_TextColour                 = 0x400f0
Wimp_TextOp                     = 0x400f9
Wimp_TransferBlock              = 0x400f1
Wimp_UpdateWindow               = 0x400c9
Wimp_WhichIcon                  = 0x400d6
                .endif


; +---------------------------------------------------------------------+
; |                                                                     |
; |   Debugging stuff.                                                  |
; |                                                                     |
; +---------------------------------------------------------------------+

                .ifdef DEBUG
BDebug_Init     = 0xa780
BDebug_Debug    = 0xa781

Trace_R0        = 0xbf00
Trace_R1        = 0xbf01
Trace_R2        = 0xbf02
Trace_R3        = 0xbf03
Trace_R4        = 0xbf04
Trace_R5        = 0xbf05
Trace_R6        = 0xbf06
Trace_R7        = 0xbf07
Trace_R8        = 0xbf08
Trace_R9        = 0xbf09
Trace_R10       = 0xbf0a
Trace_R11       = 0xbf0b
Trace_R12       = 0xbf0c
Trace_R13       = 0xbf0d
Trace_R14       = 0xbf0e
Trace_R15       = 0xbf0f
Trace_Regs      = 0xbf10
Trace_WriteC    = 0xbf11
Trace_NewLine   = 0xbf12
Trace_WriteS    = 0xbf13
Trace_WriteInline = 0xbf13
Trace_Write0    = 0xbf14
Trace_WriteN    = 0xbf15
Trace_Buffer    = 0xbf16
Trace_SetHead   = 0xbf17
Trace_RegsS     = 0xbf18
Trace_Mem       = 0xbf19
Trace_MemB      = 0xbf1a
Trace_R0B       = 0xbf20
Trace_R1B       = 0xbf21
Trace_R2B       = 0xbf22
Trace_R3B       = 0xbf23
Trace_R4B       = 0xbf24
Trace_R5B       = 0xbf25
Trace_R6B       = 0xbf26
Trace_R7B       = 0xbf27
Trace_R8B       = 0xbf28
Trace_R9B       = 0xbf29
Trace_R10B      = 0xbf2a
Trace_R11B      = 0xbf2b
Trace_R12B      = 0xbf2c
Trace_R13B      = 0xbf2d
Trace_R14B      = 0xbf2e
Trace_R15B      = 0xbf2f

                .macro  break
                stmfd   r13!,{r0,r14}
                swix    Trace_R15
                swix    BDebug_Debug
                ldmfd   r13!,{r0,r14}
                .endm
                .endif


; ----- EOF riscos.i -----

