/* #------------------------------------------------------------------------#
   |                                                                        |
   |   NWUTIL.C                                                             |
   |                                                                        |
   |   Utility subroutines for NWClient.                                    |
   |                                                                        |
   |   Copyright 1999, Frank A. Vorstenbosch.                               |
   |                                                                        |
   #------------------------------------------------------------------------# */

#define VERSION 0x00000

#include "nwclient.h"


/* +------------------------------------------------------------------------+
   |                                                                        |
   |   Utility subroutines.                                                 |
   |                                                                        |
   +------------------------------------------------------------------------+ */

#if 0
#define tolower(c)  (((c)>='A' && (c)<='Z')?(c)+('a'-'A'):(c))

int strcmp(const char *p,const char *q)
{
   while(tolower(*p)==tolower(*q))
   {  if(!*p)
         return 0;
      p++;
      q++; }

   return tolower(*q)-tolower(*p);
}

/* -------------------------------------------------------------------------- */

void strcpy(char *p,const char *q)
{
   while((*p++=*q++)!=0)
      ;
}

/* -------------------------------------------------------------------------- */

void strcat(char *p,const char *q)
{
   while(*p)
      p++;
   while((*p++=*q++)!=0)
      ;
}

/* -------------------------------------------------------------------------- */

int strlen(const char *p)
{  int i=0;
   while(*p++)
      i++;
   return i; }

/* -------------------------------------------------------------------------- */

void memset(char *p,int c,int n)
{  while(n--)
      *p++=c;
}

#endif
/* -------------------------------------------------------------------------- */

char *strdup(const char *string)
{  char *p;

   if((p=malloc(strlen(string)+1))==NULL)
      return NULL;

   strcpy(p,string);
   return p;
}
/* -------------------------------------------------------------------------- */

int RosAttrib(int Attributes)
{  int i;

   i=1<<0;
   if(Attributes&ATTR_SHARED)
      i|=1<<4;
   if(!(Attributes&ATTR_READONLY))
      i|=i<<1;
   if(Attributes&(ATTR_RENAMEINHIBIT|ATTR_DELETEINHIBIT))
      i|=(1<<3);

   return i;
}

/* -------------------------------------------------------------------------- */

extern int day_n[];
#define DELTASEC (60U*60U*24U*(365U*70U+68U/4U))

void NWToRosDate(int *Result,int Date,int Time,int Offset)
{  
   #define second    ((Time&31)<<1)
   #define minute    ((Time>>5)&63)
   #define hour      ((Time>>11)&31)
   #define year      ((Date>>9)&127)      /* years since 1980 */
   #define month     (((Date>>5)&15)-1)   /* months 0..11 */
   #define day       ((Date&31)-1)        /* day 0..30 */

   Result[1]=second+60*minute+3600*hour+86400*
	          (day+day_n[month]+(year/4)+year*365-((year&3) == 0 && month<2?1:0)+3653);

   /* ----- convert to RiscOS time --------------------------------------------- */

   mul100(Result,Result[1]+DELTASEC-Offset);

   #undef second
   #undef minute
   #undef hour
   #undef year
   #undef month
   #undef day
}

/* -------------------------------------------------------------------------- */

void RosToNWDate(int DateHi,int DateLo,short *Date,short *Time,int Offset)
{  int unix_date,day,year,nl_day,month;

   DateHi&=255;
   unix_date=((DateHi<<16)+(((DateLo+99)>>16)&0xffff))/100;

   year=unix_date*100;
   DateHi-=year>>16;
   DateLo-=year<<16;

   unix_date=(unix_date<<16)+(DateLo+99)/100;
   unix_date-=DELTASEC-Offset;

   unix_date=(unix_date+1)&~1;

   *Time=(unix_date%60)/2+(((unix_date/60)%60)<<5)+(((unix_date/3600)%24)<<11);

   day=unix_date/86400-3652;
	year=day/365;

	if((year+3)/4+365*year>day)
   year--;
	day-=(year+3)/4+365*year;

	if(day==59&&!(year&3))
   {  nl_day=day;
		month=2; }
	else
   {  nl_day=(year&3)||day<=59?day:day-1;
		for(month=0;month<12;month++)
			if(day_n[month]>nl_day)
            break;
	}
	*Date=nl_day-day_n[month-1]+1+(month<<5)+(year<<9);
}

/* -------------------------------------------------------------------------- */

int InventFileType(register struct NWClient *nw,const char *name)
{  const char *ext=name;
   int i;

   Trace("\n Invent(");
   Trace(name);
   Trace(") {");

   if(!nw->ExtensionMap)
      goto nothing; /*return 0xffffff00;*/

   while(*ext)
      ext++;
   while(ext>name && *ext!='.' && ext[-1]!='/' && ext[-1]!='\\' && ext[-1]!=':')
      ext--;

   #if 0
   if(*ext!='.')
      goto nothing; /*return 0xffffff00;*/

   Trace(" ext=");
   Trace(ext);

   ext++;
   #endif

   Trace(" ext=");
   Trace(ext);

   /* now ext points to extension */

   for(i=0;nw->ExtensionMap[i].Type;i++)
   {  
      #if 0
      if(!strcmp(nw->ExtensionMap[i].Name,ext))
      #else
      if((*ext=='.' && !strcmp(nw->ExtensionMap[i].Name,ext+1)) ||
         (*ext!='.' && *nw->ExtensionMap[i].Name=='.' && !strcmp(nw->ExtensionMap[i].Name+1,ext)))
      #endif
      {  if(i>0)
         {  int t;
            char *p;

            t=nw->ExtensionMap[i].Type;
            nw->ExtensionMap[i].Type=nw->ExtensionMap[i-1].Type;
            nw->ExtensionMap[i-1].Type=t;

            p=nw->ExtensionMap[i-1].Name;
            nw->ExtensionMap[i-1].Name=nw->ExtensionMap[i].Name;
            nw->ExtensionMap[i].Name=p;

            return t;
         }

         Trace(" type=");
         Trace(nw->ExtensionMap[i].Name);

         return nw->ExtensionMap[i].Type;
      }
   }

nothing:
   Trace("}");
   return 0xffffff00;
}


/* +------------------------------------------------------------------------+
   |                                                                        |
   |   Log a message to the nwMessage log                                   |
   |                                                                        |
   +------------------------------------------------------------------------+ */

void nwclient_logmessage(char *message)
{  int i,j,h;
   char *p,buffer[50];
   static char MessageFile[]="<wimp$scrapdir>.NwMessages";

   if((h=riscos_open(MessageFile,RO_WRONLY))==0)
      h=riscos_open(MessageFile,RO_CREAT);

   if(h)
   {  *buffer=0;

      OSWord(14,(int)buffer);
      p=buffer;
      while(*p>31)
         p++;
      i=p-buffer;

      riscos_seek(h,0,SEEK_END);
      riscos_write(h,buffer,i);
      riscos_write(h,": ",2);

      while(1)
      {  j=strlen(message);
         if(j>60)
         {  p=message+60;
            while(*p!=' ' && p>message+50)
               p--;
            while(p[-1]==' ' && p>message+50)
               p--;
         }
         else
            p=message+j;
         riscos_write(h,message,p-message);
         riscos_write(h,"\n",1);
         if(*p)
         {  while(*p==' ')
               p++;
            message=p;
            for(j=0;j<i+2;j++)
            riscos_write(h," ",1); 
         }
         else
            break;
      }

      riscos_close(h);
      riscos_settype(MessageFile,RO_TYPE_TEXT);
   }
}

/* +------------------------------------------------------------------------+
   |                                                                        |
   |   Lookup server by name.                                               |
   |                                                                        |
   +------------------------------------------------------------------------+ */

struct Server *lookup_server(const char *Name,const char **Tail,struct NWClient *nw)
{  struct Server *fs;
   char server[50];
   int i;

   Trace("\n lookup_server(\"");
   Trace(Name);
   Trace("\") {");

   if(Name)
   {
      for(i=0;Name[i] && Name[i]!='/' && Name[i]!=':' && i<49;i++)
         server[i]=Name[i];
      if(Tail && (Name[i]==':' || !Name[i]))
         i=0;
      server[i]=0;

      if(Name[i]=='/')
         i++;

      if(Tail)
         *Tail=Name+i;
   }
   else
      i=0;
   
   if(i==0 && nw->NumServers==1)
   {  FirstNode(&nw->Servers,fs);
      return fs;
   }

   forList(&nw->Servers,fs)
   {  if(!strcmp(fs->ServerName,server))
         return fs;
   }

   return NULL;
}

/* -------------------------------------------------------------------------- */

/*
   Name mapping:

   NetWare     RiscOS
      /           .     directory separator
      .           /     full stop is replaced by slash
      %           /     percent is replaced by slash
      .%                percent immediately after full stop means both are deleted
      &           +     plus sign
      #           ?     hash and questionmark have exchanged meanings
      ^           <     less than confuses NetWare big time
      $           >     greater than confuses NetWare big time
    @ SPC       \xa0    hard space
*/

#pragma On(Check_ltorg)                  /* most of these functions are too big */

struct Mount *RosToNWName(char *buffer,const char *rosName,struct NWClient *nw,int dirFlag)
{  struct Mount *mt;
   char *p,*q,*leaf;
   int flag=1,done=0;

   #if defined DEBUG && (DEBUG&2 || DEBUG&4)
   Trace("\n RosToNWName "); Trace(rosName); Trace(" nw="); TraceVal((int)nw);
   #endif

   q=buffer;
   p=(char *)rosName;
   if(*p==':')
      p++;
   while(*p && *p!='.')
      *q++=*p++;
   *q=0;

   #if defined DEBUG && DEBUG&4
   Trace(" search for \"");
   Trace(buffer);
   Trace("\"");
   #endif

   forList(&nw->Mounts,mt)
   {  
Trace(" mt="); TraceVal((int)mt); Trace(" ==\""); Trace(mt->LocalName); Trace("\"? ");
      if(!strcmp(mt->LocalName,buffer))
         break;
   }
   #if 1
   if(IsTailNode(mt))
   {
      Trace(" null }");
      return NULL;
   }
   #else
   if(IsTailNode(mt))
   {  p=(char *)rosName;
      if(*p==':')
         p++;
      mt=NULL; }
   #endif

   #if defined DEBUG && DEBUG&2
   Trace(" \"");
   Trace(buffer);
   Trace("\" ");
   #endif

   leaf=q=buffer;
   while(!done)
   {  if(flag)
      {  switch(*p)
         {  case '$':
               #if 0
               if(!mt)
               {  if(q==buffer)
                  {  memcpy(buffer,"sys:",4);
                     q+=4; }
                  else
                     q[-1]=':';
               }
               #endif
            case '&':
            case '%':
            case '@':
            case '^':
            case '\\':
               if(p[1])
                  p+=2;
               else
                  p++;
               continue;
      }  }

      flag=0;
      switch(*p)
      {  case 0:
            done=1;
         case '.':
            if(mt->Flags&MOUNT_LONGNAMES)
            {  if(q>buffer && *p)
                  *q++='/';
            }
            else
               if(q>buffer)
               {  *q=0;
                  #if defined DEBUG && DEBUG&8
                  Trace("\nscan% \"");
                  Trace(leaf);
                  TraceChar('"');
                  #endif
                  /* now scan the last filename for any excess % signs */
                  {  int i;
                     char *p=leaf;

                     i=q-leaf;
                     #if defined DEBUG && DEBUG&4
                     TraceByte(i);  /* length */
                     #endif

                     if(i>0)
                     {  if(i>8 && leaf[8]=='%')
                           leaf[8]='.';
                        else
                        {  while(--i)
                           {  if(leaf[i]=='%')
                              {  leaf[i]='.';
                                 break; }
                     }  }  }
                  }

                  #if defined DEBUG && DEBUG&8
                  Trace("\nresult% \"");
                  Trace(leaf);
                  TraceChar('"');
                  #endif

                  /* now make sure that no part is too long */

                  {  int i=0;
                     char *p=leaf;

                     while(*p && *p!='.' && i<8)
                     {  i++;
                        p++; }

                     if(i==8 && *p!='.' && *p)
                     {  char *r;
                     
                        /* move the rest two places to the right */
                        r=p;
                        while(*r)
                           r++;
                        r[2]=0;
                        while(r>p)
                        {  r[1]=r[-1];
                           r--; }
                        r[0]='.';
                        r[1]='%';
                        q+=2;
                     }
                  }
               
                  #if defined DEBUG && DEBUG&8
                  Trace("\nlenchk% \"");
                  Trace(leaf);
                  TraceChar('"');
                  #endif

                  if(*p)
                     *q++='/';
                  leaf=q;
               }
            flag=1;
            p++;
            break;
         case '/':
            if(mt->Flags&MOUNT_LONGNAMES)
               *q++='.';
            else
               *q++='%';
            p++;
            break;
         case 176:
            if(mt->Flags&MOUNT_LONGNAMES)
               *q++='%';
            else
               *q++=176;
            p++;
            break;
         case '+':
            if(mt->Flags&MOUNT_LONGNAMES)
               *q++='+';
            else
               *q++='&';
            p++;
            break;
         case 160:      /* hard space */
            if(mt->Flags&MOUNT_LONGNAMES)
               *q++=' ';
            else
               *q++='@';
            p++;
            break;
         case '?':
            *q++='#';
            p++;
            break;
         case '<':
            *q++='^';
            p++;
            break;
         case '>':
            *q++='$';
            p++;
            break;
         case 'a'..'z':
            if(!(mt->Flags&MOUNT_LONGNAMES))
            {  *q++=*p++-('a'-'A');
               break; }
         default:
            *q++=*p++;
            break;
      }
   }

   *q=0;
   #if defined DEBUG && (DEBUG&2 || DEBUG&4)
   Trace(" \"");
   Trace(buffer);
   Trace("\" ");
   #endif

   Trace(" }");

   return mt;
}

/* -------------------------------------------------------------------------- */

void NWToRosName(struct Mount *mt,char *buffer,const char *source)
{  int tmp,prev=0,count=0;

   while(*source)
   {  tmp=*source;
      switch(tmp)
      {  case ':':   /* volume */
            *buffer++='.';
            *buffer++='$';
         case '/':   /* directory */
         case '\\':
            *buffer++='.';
            count=-1;
            break;
         case '.':
            *buffer++='/';
            break;
         case '%':
            if(mt->Flags&MOUNT_LONGNAMES)
               *buffer++=176;
            else
            {
               if(prev=='.')
                  buffer--;
               else
                  *buffer++='/';
            }
            break;
         case '#':
            *buffer++='?';
            break;
         case ' ':
         case '@':      /* hard space */
            *buffer++=160;
            break;
         case '&':
            if(mt->Flags&MOUNT_LONGNAMES)
               *buffer++='&';
            else
               *buffer++='+';
            break;
         case '^':
            *buffer++='<';
            break;
         case '$':
            *buffer++='>';
            break;
         case 'A'..'Z':
            if((mt->Flags&MOUNT_LONGNAMES) || prev=='!')      /* make first character following ! uppercase */
               *buffer++=*source;
            else
               *buffer++=*source+'a'-'A';
            break;
         default:
            *buffer++=*source;
      }
      source++;
      prev=tmp;
      count++;
   }
   *buffer=0;
}

/* ----- EOF NWUTIL.C ----- */

