/* #------------------------------------------------------------------------#
   |                                                                        |
   |   NWNDS.C                                                              |
   |                                                                        |
   |   NDS and bindery functions for NWClient.                              |
   |                                                                        |
   |   Copyright 1999, Frank A. Vorstenbosch.                               |
   |                                                                        |
   #------------------------------------------------------------------------# */

/* $Id: nwnds.c,v 1.6 2001/12/22 12:19:50 frank Exp $ */

#define VERSION 0x00000

#include "nwclient.h"


/* +------------------------------------------------------------------------+
   |                                                                        |
   |   Password encryption functions.                                       |
   |                                                                        |
   +------------------------------------------------------------------------+ */

/* This code has been taken from DDJ 11/93, from an article by Pawel Szczerbina.

   Password encryption converted to C from Barry Nance's Pascal
   prog published in the March -93 issue of Byte.
*/

/******************* Data types ***************************/
typedef unsigned char buf32[32];
typedef unsigned char buf16[16];
typedef unsigned char buf8[8];
typedef unsigned char buf4[4];

static unsigned char encrypttable[256] =
{0x7, 0x8, 0x0, 0x8, 0x6, 0x4, 0xE, 0x4, 0x5, 0xC, 0x1, 0x7, 0xB, 0xF, 0xA, 0x8,
0xF, 0x8, 0xC, 0xC, 0x9, 0x4, 0x1, 0xE, 0x4, 0x6, 0x2, 0x4, 0x0, 0xA, 0xB, 0x9,
0x2, 0xF, 0xB, 0x1, 0xD, 0x2, 0x1, 0x9, 0x5, 0xE, 0x7, 0x0, 0x0, 0x2, 0x6, 0x6,
0x0, 0x7, 0x3, 0x8, 0x2, 0x9, 0x3, 0xF, 0x7, 0xF, 0xC, 0xF, 0x6, 0x4, 0xA, 0x0,
0x2, 0x3, 0xA, 0xB, 0xD, 0x8, 0x3, 0xA, 0x1, 0x7, 0xC, 0xF, 0x1, 0x8, 0x9, 0xD,
0x9, 0x1, 0x9, 0x4, 0xE, 0x4, 0xC, 0x5, 0x5, 0xC, 0x8, 0xB, 0x2, 0x3, 0x9, 0xE,
0x7, 0x7, 0x6, 0x9, 0xE, 0xF, 0xC, 0x8, 0xD, 0x1, 0xA, 0x6, 0xE, 0xD, 0x0, 0x7,
0x7, 0xA, 0x0, 0x1, 0xF, 0x5, 0x4, 0xB, 0x7, 0xB, 0xE, 0xC, 0x9, 0x5, 0xD, 0x1,
0xB, 0xD, 0x1, 0x3, 0x5, 0xD, 0xE, 0x6, 0x3, 0x0, 0xB, 0xB, 0xF, 0x3, 0x6, 0x4,
0x9, 0xD, 0xA, 0x3, 0x1, 0x4, 0x9, 0x4, 0x8, 0x3, 0xB, 0xE, 0x5, 0x0, 0x5, 0x2,
0xC, 0xB, 0xD, 0x5, 0xD, 0x5, 0xD, 0x2, 0xD, 0x9, 0xA, 0xC, 0xA, 0x0, 0xB, 0x3,
0x5, 0x3, 0x6, 0x9, 0x5, 0x1, 0xE, 0xE, 0x0, 0xE, 0x8, 0x2, 0xD, 0x2, 0x2, 0x0,
0x4, 0xF, 0x8, 0x5, 0x9, 0x6, 0x8, 0x6, 0xB, 0xA, 0xB, 0xF, 0x0, 0x7, 0x2, 0x8,
0xC, 0x7, 0x3, 0xA, 0x1, 0x4, 0x2, 0x5, 0xF, 0x7, 0xA, 0xC, 0xE, 0x5, 0x9, 0x3,
0xE, 0x7, 0x1, 0x2, 0xE, 0x1, 0xF, 0x4, 0xA, 0x6, 0xC, 0x6, 0xF, 0x4, 0x3, 0x0,
 0xC, 0x0, 0x3, 0x6, 0xF, 0x8, 0x7, 0xB, 0x2, 0xD, 0xC, 0x6, 0xA, 0xA, 0x8, 0xD};

static buf32 encryptkeys =
{0x48, 0x93, 0x46, 0x67, 0x98, 0x3D, 0xE6, 0x8D,
 0xB7, 0x10, 0x7A, 0x26, 0x5A, 0xB9, 0xB1, 0x35,
 0x6B, 0x0F, 0xD5, 0x70, 0xAE, 0xFB, 0xAD, 0x11,
 0xF4, 0x47, 0xDC, 0xA7, 0xEC, 0xCF, 0x50, 0xC0};

/* -------------------------------------------------------------------------- */

static void shuffle1(buf32 temp, unsigned char *target)
{
	short b4;
	unsigned char b3;
	int s, b2, i;

	b4 = 0;

	for (b2 = 0; b2 <= 1; ++b2)
	{
		for (s = 0; s <= 31; ++s)
		{
			b3 = (temp[s] + b4) ^ (temp[(s + b4) & 31] - encryptkeys[s]);
			b4 = b4 + b3;
			temp[s] = b3;
		}
	}

	for (i = 0; i <= 15; ++i)
	{
		target[i] = encrypttable[temp[2 * i]]
		    | (encrypttable[temp[2 * i + 1]] << 4);
	}
}


void shuffle(const unsigned char *lon, const unsigned char *buf, int buflen,
	          unsigned char *target)
{
	int b2, d, s;
	buf32 temp;

	while ((buflen > 0)
	       && (buf[buflen - 1] == 0))
	{
		buflen = buflen - 1;
	}

	for (s = 0; s < 32; s++)
	{
		temp[s] = 0;
	}

	d = 0;
	while (buflen >= 32)
	{
		for (s = 0; s <= 31; ++s)
		{
			temp[s] = temp[s] ^ buf[d];
			d = d + 1;
		}
		buflen = buflen - 32;
	}
	b2 = d;
	if (buflen > 0)
	{
		for (s = 0; s <= 31; ++s)
		{
			if (d + buflen == b2)
			{
				b2 = d;
				temp[s] = temp[s] ^ encryptkeys[s];
			} else
			{
				temp[s] = temp[s] ^ buf[b2];
				b2 = b2 + 1;
			}
		}
	}
	for (s = 0; s <= 31; ++s)
		temp[s] = temp[s] ^ lon[s & 3];

	shuffle1(temp, target);
}


void nw_encrypt(const unsigned char *fra,const unsigned char *buf,unsigned char *til)
{
	buf32 k;
	int s;

	shuffle(&(fra[0]), buf, 16, &(k[0]));
	shuffle(&(fra[4]), buf, 16, &(k[16]));

	for (s = 0; s <= 15; ++s)
		k[s] = k[s] ^ k[31 - s];

	for (s = 0; s <= 7; ++s)
		til[s] = k[s] ^ k[15 - s];
}


/*****************************************************************************/
/*                                                                           */
/*  The following code was contributed by                                    */
/*  Guntram Blohm  <gbl%th7csun1@str.daimler-benz.com>                       */
/*                                                                           */
/*****************************************************************************/

static char newshuffle[256 + 16] =
{
	0x0f, 0x08, 0x05, 0x07, 0x0c, 0x02, 0x0e, 0x09,
	0x00, 0x01, 0x06, 0x0d, 0x03, 0x04, 0x0b, 0x0a,
	0x02, 0x0c, 0x0e, 0x06, 0x0f, 0x00, 0x01, 0x08,
	0x0d, 0x03, 0x0a, 0x04, 0x09, 0x0b, 0x05, 0x07,

	0x05, 0x02, 0x09, 0x0f, 0x0c, 0x04, 0x0d, 0x00,
	0x0e, 0x0a, 0x06, 0x08, 0x0b, 0x01, 0x03, 0x07,
	0x0f, 0x0d, 0x02, 0x06, 0x07, 0x08, 0x05, 0x09,
	0x00, 0x04, 0x0c, 0x03, 0x01, 0x0a, 0x0b, 0x0e,

	0x05, 0x0e, 0x02, 0x0b, 0x0d, 0x0a, 0x07, 0x00,
	0x08, 0x06, 0x04, 0x01, 0x0f, 0x0c, 0x03, 0x09,
	0x08, 0x02, 0x0f, 0x0a, 0x05, 0x09, 0x06, 0x0c,
	0x00, 0x0b, 0x01, 0x0d, 0x07, 0x03, 0x04, 0x0e,

	0x0e, 0x08, 0x00, 0x09, 0x04, 0x0b, 0x02, 0x07,
	0x0c, 0x03, 0x0a, 0x05, 0x0d, 0x01, 0x06, 0x0f,
	0x01, 0x04, 0x08, 0x0a, 0x0d, 0x0b, 0x07, 0x0e,
	0x05, 0x0f, 0x03, 0x09, 0x00, 0x02, 0x06, 0x0c,

	0x05, 0x03, 0x0c, 0x08, 0x0b, 0x02, 0x0e, 0x0a,
	0x04, 0x01, 0x0d, 0x00, 0x06, 0x07, 0x0f, 0x09,
	0x06, 0x00, 0x0b, 0x0e, 0x0d, 0x04, 0x0c, 0x0f,
	0x07, 0x02, 0x08, 0x0a, 0x01, 0x05, 0x03, 0x09,

	0x0b, 0x05, 0x0a, 0x0e, 0x0f, 0x01, 0x0c, 0x00,
	0x06, 0x04, 0x02, 0x09, 0x03, 0x0d, 0x07, 0x08,
	0x07, 0x02, 0x0a, 0x00, 0x0e, 0x08, 0x0f, 0x04,
	0x0c, 0x0b, 0x09, 0x01, 0x05, 0x0d, 0x03, 0x06,

	0x07, 0x04, 0x0f, 0x09, 0x05, 0x01, 0x0c, 0x0b,
	0x00, 0x03, 0x08, 0x0e, 0x02, 0x0a, 0x06, 0x0d,
	0x09, 0x04, 0x08, 0x00, 0x0a, 0x03, 0x01, 0x0c,
	0x05, 0x0f, 0x07, 0x02, 0x0b, 0x0e, 0x06, 0x0d,

	0x09, 0x05, 0x04, 0x07, 0x0e, 0x08, 0x03, 0x01,
	0x0d, 0x0b, 0x0c, 0x02, 0x00, 0x0f, 0x06, 0x0a,
	0x09, 0x0a, 0x0b, 0x0d, 0x05, 0x03, 0x0f, 0x00,
	0x01, 0x0c, 0x08, 0x07, 0x06, 0x04, 0x0e, 0x02,

	0x03, 0x0e, 0x0f, 0x02, 0x0d, 0x0c, 0x04, 0x05,
	0x09, 0x06, 0x00, 0x01, 0x0b, 0x07, 0x0a, 0x08,
};

/* -------------------------------------------------------------------------- */

void newpassencrypt(char *old, char *new, char *out)
{
	char *p, *bx;
	char copy[8];
	int i, di, ax;
	char cl, dl, ch;

	memcpy(copy, new, 8);

	for (i = 0; i < 16; i++)
	{
		for (di = 0, ax = 0, p = old; di < 8; di++, ax += 0x20, p++)
		{
			cl = newshuffle[(((copy[di] ^ *p) >> 4) & 0x0f) + ax + 0x10] << 4;
			dl = newshuffle[((copy[di] ^ *p) & 0xf) + ax];
			copy[di] = cl | dl;
		}

		ch = old[7];
		for (bx = old + 7; bx > old; bx--)
		{
			*bx = ((bx[-1] >> 4) & 0x0f) | ((*bx) << 4);
		}
		*old = ((ch >> 4) & 0x0f) | (*old) << 4;

		memset(out, '\0', 8);

		for (di = 0; di < 16; di++)
		{
			if (newshuffle[di + 0x100] & 1)
				ch = ((copy[newshuffle[di + 0x100] / 2] >> 4) & 0x0f);
			else
				ch = copy[newshuffle[di + 0x100] / 2] & 0x0f;
			out[di / 2] |= ((di & 1) ? ch << 4 : ch);
		}
		memcpy(copy, out, 8);
	}
}

/* -------------------------------------------------------------------------- */

int ncp_get_encryption_key(register struct Server *fs,char *target)
{  int r;

   fs->request.header.Function=0x17;
   fs->request.payload.fn_17.Length=1;
   fs->request.payload.fn_17.SubFunction=0x17; /* get login encryption key */
   if((r=ncp_request(REQ_17,"8b",NULL,fs))!=0)
      return r;

   memcpy(target,fs->nw->reply.payload.fn_17_17.Key,8);
	return 0;
}

/* -------------------------------------------------------------------------- */

int ncp_get_bindery_object_id(register struct Server *fs,int type,const char *name,struct ncp_bindery_object *target)
{  int r;
   struct NWClient *nw=fs->nw;

   Trace("\n ncp_get_bindery_object_id(");
   TraceVal(type);
   Trace(name);

   fs->request.header.Function=0x17;
   fs->request.payload.fn_17.Length=1+2+1+strlen(name);
   fs->request.payload.fn_17.SubFunction=0x35;
   fs->request.payload.fn_17_35.Type=type;
   fs->request.payload.fn_17_35.Name=name;   /* counted string */

   if((r=ncp_request(REQ_17"Wc","LW48b",NULL,fs))!=0)
      return r;

   target->object_id=nw->reply.payload.fn_17_35.ID;
	target->object_type=nw->reply.payload.fn_17_35.Type;
	memcpy(target->object_name,nw->reply.payload.fn_17_35.Name,48);

	return 0;
}

/* -------------------------------------------------------------------------- */

static int ncp_login_encrypted(register struct Server *fs,const struct ncp_bindery_object *object,
		    const char *key,const char *passwd)
{  int tmpID = htonl(object->object_id);
	unsigned char buf[128];
	unsigned char encrypted[8];

   shuffle((unsigned const char *)&tmpID,(unsigned const char *)passwd,strlen(passwd),buf);
	nw_encrypt((const unsigned char *)key,(const unsigned char *)buf,(unsigned char *)encrypted);

   fs->request.header.Function=0x17;
   fs->request.payload.fn_17.Length=1+8+2+1+strlen(object->object_name);
   fs->request.payload.fn_17.SubFunction=0x18;
   memcpy(fs->request.payload.fn_17_18.Password,encrypted,8);
   fs->request.payload.fn_17_18.Type=object->object_type;
   fs->request.payload.fn_17_18.Name=object->object_name;   /* counted string */

   return ncp_request(REQ_17"8bWc",NULL,NULL,fs);
}

/* -------------------------------------------------------------------------- */

static int ncp_login_unencrypted(register struct Server *fs,int login_type,const char *username,const char *password)
{
   #if defined DEBUG && (DEBUG&2)
   Trace("\n ncp_login_unencrypted \n");
   #endif

   fs->request.header.Function=0x17;
   fs->request.payload.fn_17.Length=1+2+1+strlen(username)+1+strlen(password);
   fs->request.payload.fn_17.SubFunction=0x14;
   fs->request.payload.fn_17_14.Type=login_type;
   fs->request.payload.fn_17_14.Name=username;        /* counted string */
   fs->request.payload.fn_17_14.Password=password;    /* counted string */

   return ncp_request(REQ_17"Wcc",NULL,NULL,fs);
}

/* -------------------------------------------------------------------------- */

static int ncp_login_object(register struct Server *fs,const char *username,int login_type,const char *password)
{  int r;
	char ncp_key[8];
	struct ncp_bindery_object user;

   if((r=ncp_get_encryption_key(fs,ncp_key))==NCP_NCP_NOT_SUPPORTED)
      return ncp_login_unencrypted(fs,login_type,username,password);
   if(r)
      return r;

   if((r=ncp_get_bindery_object_id(fs,login_type,username,&user))<0)
      return r;

   return ncp_login_encrypted(fs,&user,ncp_key,password);
}

/* -------------------------------------------------------------------------- */

int ncp_login_user(register struct Server *fs,const char *username,const char *password)
{
	return ncp_login_object(fs,username,NCP_TYPE_USER,password);
}


/* +------------------------------------------------------------------------+
   |                                                                        |
   |   NDS access.                                                          |
   |                                                                        |
   +------------------------------------------------------------------------+ */

int nwclient_scanobject(int objectType,const char *objectName,int sequence,
                        struct scan_object **result,register struct Server *fs)
{  int r;
   struct NWClient *nw=fs->nw;

   fs->request.header.Function=0x17;
   fs->request.payload.fn_17.Length=8+strlen(objectName);
   fs->request.payload.fn_17.SubFunction=0x37;
   fs->request.payload.fn_17_37.Sequence=sequence;
   fs->request.payload.fn_17_37.Type=objectType;
   fs->request.payload.fn_17_37.Name=objectName;

   if((r=ncp_request(REQ_17"LWc","LW48s3b",(char *)(&nw->reply.payload.fn_17_37+1),fs))!=0)
   {  nw->reply.payload.fn_17_3c.Sequence=-1;
      return r; }

   *result=&nw->reply.payload.fn_17_37;

   return 0;
}

/* -------------------------------------------------------------------------- */

int nwclient_scanprop(int objectType,const char *objectName,int sequence,
                      struct scan_property **result,register struct Server *fs)
{  int r;
   struct NWClient *nw=fs->nw;

   fs->request.header.Function=0x17;
   fs->request.payload.fn_17.Length=10+strlen(objectName);
   fs->request.payload.fn_17.SubFunction=0x3c;
   fs->request.payload.fn_17_3c.Type=objectType;
   fs->request.payload.fn_17_3c.Name=objectName;
   fs->request.payload.fn_17_3c.Sequence=sequence;

   if((r=ncp_request(REQ_17"WcLk\001k*","16sbbLbb",(char *)(&nw->reply.payload.fn_17_3c+1),fs))!=0)
   {  nw->reply.payload.fn_17_3c.Sequence=-1;
      return r; }

   if(!nw->reply.payload.fn_17_3c.More)
      nw->reply.payload.fn_17_3c.Sequence=-1;

   *result=&nw->reply.payload.fn_17_3c;

   return 0;
}

/* -------------------------------------------------------------------------- */

int nwclient_readprop(int objectType,const char *objectName,const char *propName,
                      int segment,struct read_property **result,
                      register struct Server *fs)
{
   struct NWClient *nw=fs->nw;

   fs->request.header.Function=0x17;
   fs->request.payload.fn_17.Length=1+3+2+strlen(objectName)+strlen(propName);
   fs->request.payload.fn_17.SubFunction=0x3d;
   fs->request.payload.fn_17_3d.Type=objectType;
   fs->request.payload.fn_17_3d.ObjectName=objectName;
   fs->request.payload.fn_17_3d.Segment=segment;
   fs->request.payload.fn_17_3d.PropName=propName;

   *result=&nw->reply.payload.fn_17_3d;

   return ncp_request(REQ_17"Wcbc","64b66b",NULL,fs);
}


/* ----- EOF NWNDS.C ----- */

