/* #------------------------------------------------------------------------#
   |                                                                        |
   |   GATE.C                                                               |
   |                                                                        |
   |   IPX gateway between Ethernet and Econet.                             |
   |                                                                        |
   |   Copyright 1999, Frank A. Vorstenbosch                                |
   |                                                                        |
   #------------------------------------------------------------------------# */

/* $Id: gate.c,v 1.4 2001/12/22 12:19:50 frank Exp $ */

#include "gateway.h"

/* +------------------------------------------------------------------------+
   |                                                                        |
   |   Function prototypes, constant data, etc.                             |
   |                                                                        |
   +------------------------------------------------------------------------+ */

const char SapMessages[4*4]={ 0,3,NCP_TYPE_NDS_SERVER>>8,NCP_TYPE_NDS_SERVER&255,
                              0,3,NCP_TYPE_386_SERVER>>8,NCP_TYPE_386_SERVER&255,
                              0,3,NCP_TYPE_NDS_SERVER>>8,NCP_TYPE_NDS_SERVER&255,
                              0,3,NCP_TYPE_FILESERVER>>8,NCP_TYPE_FILESERVER&255 };


/* +------------------------------------------------------------------------+
   |                                                                        |
   |   Init and exit functions.                                             |
   |                                                                        |
   +------------------------------------------------------------------------+ */

struct GateWay *gateway_init(struct RiscIPX *ri)
{  struct GateWay *gw;
   struct kernel_error *err;

   Trace("\n gateway_init");

   if((err=AllocMem(sizeof(struct GateWay),(int **)&gw))!=NULL)
   {  if(!err->errorcode)
         err->errorcode=-1;
      return (struct GateWay *)err; }

   memset((char *)gw,0,sizeof(struct GateWay));
   TraceVal((int)gw);

   gw->ri=ri;

   NewList(&gw->Servers);

   /* ----- now open our socket ------------------------------------------------ */

   Trace(" ok, gw=");
   TraceVal((int)gw);

   return gw;
}

/* -------------------------------------------------------------------------- */

struct kernel_error *gateway_exit(register struct GateWay *gw)
{  
   Trace("\n gateway_exit");

   if(gw->TaskHandle)
      Wimp_CloseDown(gw->TaskHandle,TASK);

   free(gw);
   return 0;
}


/* -------------------------------------------------------------------------- */

static int saphandler(struct mbuf *mb,struct UnpackedHeader *header,void *gwptr)
{  register struct GateWay *gw=gwptr;
   
   Trace("\n saphandler");
   gw->Packet=1;
   return 1;
}


/* +------------------------------------------------------------------------+
   |                                                                        |
   |   Display internal state.                                              |
   |                                                                        |
   +------------------------------------------------------------------------+ */

char *OurName(register struct GateWay *gw)
{  char *p=((char *)gw->Buffer);

   strcpy(p,ModuleName);
   strcat(p," ");
   p+=strlen(p);
   memcpy(p,Version,4);
   p[4]=0;

   return ((char *)gw->Buffer);
}

/* -------------------------------------------------------------------------- */

struct kernel_error *StarStatus(const char *commandTail,int numParms,register struct GateWay *gw)
{  
   riscos_puts(OurName(gw));
   riscos_puts("\r\n");

   return NULL;
}


/* +------------------------------------------------------------------------+
   |                                                                        |
   |   Main loop for RiscOS multitasking.                                   |
   |                                                                        |
   +------------------------------------------------------------------------+ */

void gateway(register struct GateWay *gw,const char *commandTail)
{  static int Messages[2]={0x502,0};   /* messages we're interested in */
   struct kernel_error *err=NULL;
   struct mbuf *mb;
   struct SAPEntry sappkt;
   struct Address addr={0,"\xff\xff\xff\xff\xff\xff",IPX_SKT_SAP};
   struct Server *fs,*tmp;
   int i,
       time,
       broadcast,    /* time for the next RIP and SAP broadcast */
       sapreq=3*4,   /* attempt 12 SAP broadcasts to fill up tables */
       run=500;      /* every 5 seconds */
   
   Trace("\n gateway");

   /* ----- initialize --------------------------------------------------------- */

   if(gw->TaskHandle)
      Wimp_CloseDown(gw->TaskHandle,TASK);
   gw->TaskHandle=Wimp_Initialise(310,TASK,OurName(gw),Messages);

   if((gw->SapSocket=ipx_socket(gw->ri))!=NULL &&
      (ipx_bind(gw->SapSocket,0,0,gw->ri) ||
       ipx_connect(gw->SapSocket,IPX_PT_NCP,&addr,gw->ri) ||
       ipx_recv_handler(gw->SapSocket,&saphandler,gw,gw->ri)))
   {  ipx_close(gw->SapSocket,gw->ri);
      gw->SapSocket=NULL; }

   if(!gw->SapSocket)
      err=&Error_SapSocket;

   /* ----- main loop ---------------------------------------------------------- */

   broadcast=MonotonicTime()+60*100;

   while(run && !err)
   {  err=NULL;

      time=MonotonicTime();

      switch(Wimp_PollIdle((1<<4)|(1<<5)|(1<<6)|(1<<11)|(1<<12)|(1<<22),gw->Buffer,time+run,&gw->Packet))
      {  case 0: /* null */
            if(sapreq)
            {  Trace("\n broadcast");
               TraceVal(sapreq);
               ipx_send_unsafe(gw->SapSocket,(void *)(SapMessages+((sapreq&3)<<2)),4,gw->ri);
               sapreq--; }

            forList2(&gw->Servers,fs,tmp)
            {  if((fs->Destroy-time)>0)
               {  RemoveNode(fs);
                  free(fs); }
            }

            break;

         case 13: /* pollword nonzero */
            gw->Packet=0;
            break;

         case 17: /* user message */
         case 18:
            if(gw->Buffer[4]==0)
               run=0;
            break;
      }

      while((mb=ipx_recv_mbuf(gw->SapSocket,gw->ri))!=NULL)
      {
         #if defined DEBUG && DEBUG&2
         Trace("\n mbuf, ft=");
         TraceVal(mb->type);
         #endif

         while((i=UnpackN(mb->next,&sappkt,"WW48bA",NULL,mb->pkthdr.len))>0)
         {  mb->pkthdr.len+=i;

            sappkt.Name[32]=0;
            for(i=31;i>=0;i--)
            {  if(sappkt.Name[i]=='_')
                  sappkt.Name[i]=0;
               else
                  break; }

            #if defined DEBUG && DEBUG&2
            Trace("\n SAP ");
            Trace(sappkt.Name);
            #endif
         } /* while(sap entries) */

         gw->ri->mbctl.freem(&gw->ri->mbctl,mb);
      }

      if((MonotonicTime()-broadcast)>0)
      {  Trace("\n Time to do another broadcast");

         #if 0

         Now check all five possible frame types.
         If a route was never advertised on this frame type,
         then add it to the outgoing RIP packet.

         for(ft=1;ft<=5;ft++)
         {
            TraceVal(ft);

            rt=0;
            while((err=RouteList(&rt,&network,&hops,&flags,&node))==NULL)
            {
            }

         }
         #endif

         broadcast=MonotonicTime()+60*100;
      }
   }

   /* ----- clean up ----------------------------------------------------------- */

   if(err)
      ReportError(err,1,ModuleName);

   if(gw->SapSocket)
      ipx_close(gw->SapSocket,gw->ri);

   if(gw->TaskHandle)
   {  Wimp_CloseDown(gw->TaskHandle,TASK);
      gw->TaskHandle=0; }
}


/* ----- EOF GATEWAY.C ----- */
